package com.androidbook.pettracker;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

import com.androidbook.pettracker.PetTrackerDatabase.PetType;
import com.androidbook.pettracker.PetTrackerDatabase.Pets;

// Ekran listy zwierzaków.
public class PetTrackerListActivity extends PetTrackerActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		
		super.onCreate(savedInstanceState);
		setContentView(R.layout.showpets);
		
		// Wypełnienie kontrolki TableLayout danymi z bazy.
		fillPetList();
		
		// Obsługa przycisku dodania zwierzaka.
		final Button gotoEntry = (Button) findViewById(R.id.ButtonEnterMorePets);
		gotoEntry.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				// Przejście do innej aktywności, wyświetlającej listę.
				finish();
			}
		});
	}
	

	
	public void fillPetList()
	{
		// TableLayout w której będzie wyświetlana lista zwierzaków.
		final TableLayout petTable = (TableLayout) findViewById(R.id.TableLayout_PetList);
		
		// Zapytanie SQL
		SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
		queryBuilder.setTables(Pets.PETS_TABLE_NAME +", " +PetType.PETTYPE_TABLE_NAME);
		queryBuilder.appendWhere(Pets.PETS_TABLE_NAME + "." + Pets.PET_TYPE_ID + "=" + PetType.PETTYPE_TABLE_NAME + "." + PetType._ID);

		// Pobranie bazy danych i wykonanie zapytania.
        SQLiteDatabase db = mDatabase.getReadableDatabase();
        String asColumnsToReturn[] = { Pets.PETS_TABLE_NAME + "." + Pets.PET_NAME, Pets.PETS_TABLE_NAME + "." + Pets._ID, PetType.PETTYPE_TABLE_NAME + "." +PetType.PET_TYPE_NAME };
        Cursor c = queryBuilder.query(db, asColumnsToReturn, null, null, null, null, Pets.DEFAULT_SORT_ORDER);

        // Wyświetlenie wyników poprzez dodawanie kontrolek Tablerow do istniejącego układu TableLayout
		if(c.moveToFirst())
		{
			for(int i = 0; i< c.getCount(); i++)
			{
				TableRow newRow = new TableRow(this);
				TextView nameCol = new TextView(this);
				TextView typeCol = new TextView(this);		
				Button deleteButton = new Button(this);
						
				newRow.setTag(c.getInt(c.getColumnIndex(Pets._ID)));		// ustawiamy pole znacznika w kontrolce TableRow, byśmy wiedzieli który rekord usunąć.
				nameCol.setText(c.getString(c.getColumnIndex(Pets.PET_NAME)));
				typeCol.setText(c.getString(c.getColumnIndex(PetType.PET_TYPE_NAME)));
				

				deleteButton.setText("Usuń");
				deleteButton.setTag(c.getInt(c.getColumnIndex(Pets._ID)));		// ustawiamy pole znacznika w przycisku, by znać ID rekordu do usunięcia. 
				deleteButton.setOnClickListener(new View.OnClickListener() {
					public void onClick(View v) {

						// Usunięcie zwierzaka.
						Integer id = (Integer) v.getTag();
						deletePet(id);
						
						// Odszukanie i usunięcie z tabeli rekordu zwierzaka o określonym identyfikatorze.
						final TableLayout petTable = (TableLayout) findViewById(R.id.TableLayout_PetList);
						// To wywołanie powinno zwrócić kontrolkę TableRow, jako pierwszy widok w układzie oznaczony znacznikiem,
						// choć wygodniej by było, gdyby zwracana była tablica wszystkich widoków z danym znacznikiem.
						View viewToDelete = petTable.findViewWithTag(id);
						petTable.removeView(viewToDelete);
						
						
					}
				});
				
				newRow.addView(nameCol);
				newRow.addView(typeCol);
				newRow.addView(deleteButton);
				petTable.addView(newRow);
				c.moveToNext();
			}
		}
		else
		{
			TableRow newRow = new TableRow(this);
			TextView noResults = new TextView(this);
			noResults.setText("Brak wyników.");
			newRow.addView(noResults);
			petTable.addView(newRow);
		}
		c.close();
		db.close();
		
	}
	
	public void deletePet(Integer id)
	{
        SQLiteDatabase db = mDatabase.getWritableDatabase();
		String astrArgs[] = { id.toString() };
        db.delete(Pets.PETS_TABLE_NAME, Pets._ID + "=?",astrArgs );
        db.close();
		
		
	}

}
